<?php
// api/endpoints/auth.php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

include_once '../config/database.php';
include_once '../models/User.php';

$database = new Database();
$db = $database->getConnection();

$user = new User($db);

$request_method = $_SERVER["REQUEST_METHOD"];

switch ($request_method) {
    case 'POST':
        $data = json_decode(file_get_contents("php://input"));

        if (!empty($data->username) && !empty($data->password)) {
            $user->username = $data->username;
            $user->password = $data->password;

            if ($user->login()) {
                http_response_code(200);
                echo json_encode(array(
                    "message" => "Giriş başarılı.",
                    "user" => array(
                        "id" => $user->id,
                        "username" => $user->username,
                        "role" => $user->role
                    )
                ));
            } else {
                http_response_code(401); // Yetkisiz
                echo json_encode(array("message" => "Geçersiz kullanıcı adı veya şifre."));
            }
        } else {
            http_response_code(400); // Kötü istek
            echo json_encode(array("message" => "Kullanıcı adı ve şifre gerekli."));
        }
        break;

    default:
        http_response_code(405);
        echo json_encode(array("message" => "Geçersiz istek metodu."));
        break;
}
?>
