<?php
// api/endpoints/products.php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

include_once '../config/database.php';
include_once '../models/Product.php';
include_once '../models/User.php'; // Kullanıcı rolünü kontrol etmek için

$database = new Database();
$db = $database->getConnection();

$product = new Product($db);
$user_model = new User($db); // User modelini başlat

$request_method = $_SERVER["REQUEST_METHOD"];

// Yetkilendirme kontrolü için yardımcı fonksiyon
function authorize_manager($db_conn, $username) {
    $user_model_check = new User($db_conn);
    $user_model_check->username = $username;
    if ($user_model_check->getRoleByUsername() && $user_model_check->role === 'manager') {
        return true;
    }
    return false;
}

switch ($request_method) {
    case 'GET':
        // Ürünleri oku (Herkese açık)
        if (!empty($_GET["id"])) {
            $product->id = $_GET["id"];
            $product->readOne();
            if ($product->name != null) {
                $product_arr = array(
                    "id" => $product->id,
                    "name" => $product->name,
                    "price" => $product->price,
                    "stock" => $product->stock,
                    "image" => $product->image
                );
                http_response_code(200);
                echo json_encode($product_arr);
            } else {
                http_response_code(404);
                echo json_encode(array("message" => "Ürün bulunamadı."));
            }
        } else {
            $stmt = $product->read();
            $num = $stmt->rowCount();

            if ($num > 0) {
                $products_arr = array();
                $products_arr["records"] = array();

                while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
                    extract($row);
                    $product_item = array(
                        "id" => $id,
                        "name" => $name,
                        "price" => $price,
                        "stock" => $stock,
                        "image" => $image
                    );
                    array_push($products_arr["records"], $product_item);
                }
                http_response_code(200);
                echo json_encode($products_arr);
            } else {
                http_response_code(404);
                echo json_encode(array("message" => "Hiç ürün bulunamadı."));
            }
        }
        break;

    case 'POST':
    case 'PUT':
    case 'DELETE':
        // Bu işlemler sadece yöneticiler için
        $data = json_decode(file_get_contents("php://input"));
        $authorized_username = isset($data->username) ? $data->username : '';

        if (!authorize_manager($db, $authorized_username)) {
            http_response_code(403); // Yasak
            echo json_encode(array("message" => "Bu işlem için yönetici yetkisi gereklidir."));
            exit();
        }

        // Yetkilendirme başarılı, şimdi işlemi yap
        if ($request_method == 'POST') {
            // Yeni ürün oluştur
            if (
                !empty($data->name) &&
                !empty($data->price) &&
                isset($data->stock)
            ) {
                $product->name = $data->name;
                $product->price = $data->price;
                $product->stock = $data->stock;
                $product->image = isset($data->image) ? $data->image : '';

                if ($product->create()) {
                    http_response_code(201);
                    echo json_encode(array("message" => "Ürün başarıyla oluşturuldu."));
                } else {
                    http_response_code(503);
                    echo json_encode(array("message" => "Ürün oluşturulamadı."));
                }
            } else {
                http_response_code(400);
                echo json_encode(array("message" => "Ürün oluşturulamadı. Veri eksik."));
            }
        } elseif ($request_method == 'PUT') {
            // Ürün güncelle
            if (
                !empty($data->id) &&
                !empty($data->name) &&
                !empty($data->price) &&
                isset($data->stock)
            ) {
                $product->id = $data->id;
                $product->name = $data->name;
                $product->price = $data->price;
                $product->stock = $data->stock;
                $product->image = isset($data->image) ? $data->image : '';

                if ($product->update()) {
                    http_response_code(200);
                    echo json_encode(array("message" => "Ürün başarıyla güncellendi."));
                } else {
                    http_response_code(503);
                    echo json_encode(array("message" => "Ürün güncellenemedi."));
                }
            } else {
                http_response_code(400);
                echo json_encode(array("message" => "Ürün güncellenemedi. Veri eksik veya ID belirtilmedi."));
            }
        } elseif ($request_method == 'DELETE') {
            // Ürün sil
            if (!empty($data->id)) {
                $product->id = $data->id;

                if ($product->delete()) {
                    http_response_code(200);
                    echo json_encode(array("message" => "Ürün başarıyla silindi."));
                } else {
                    http_response_code(503);
                    echo json_encode(array("message" => "Ürün silinemedi."));
                }
            } else {
                http_response_code(400);
                echo json_encode(array("message" => "Ürün silinemedi. ID belirtilmedi."));
            }
        }
        break;

    default:
        http_response_code(405);
        echo json_encode(array("message" => "Geçersiz istek metodu."));
        break;
}
?>
