<?php
// api/index.php

// Gelen isteğin yolunu al
$request_uri = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);
$request_uri = trim($request_uri, '/'); // Baştaki ve sondaki '/' karakterlerini kaldır

// Root klasör adını al
$script_name = dirname($_SERVER['SCRIPT_NAME']);
$script_name = trim($script_name, '/');

// Eğer root klasörü boş değilse, request_uri'den çıkar
if (!empty($script_name) && strpos($request_uri, $script_name) === 0) {
    $request_uri = substr($request_uri, strlen($script_name));
    $request_uri = trim($request_uri, '/');
}

// URL'yi parçalara ayır
$uri_segments = explode('/', $request_uri);

// İlk segment API kaynağını belirler (örn: products, orders, auth)
$resource = array_shift($uri_segments);

// Kaynak bazında API dosyasını dahil et
switch ($resource) {
    case 'products':
        require_once 'endpoints/products.php';
        break;
    case 'orders':
        require_once 'endpoints/orders.php';
        break;
    case 'auth': // Yeni auth endpoint'i
        require_once 'endpoints/auth.php';
        break;
    default:
        // Kaynak bulunamazsa 404 gönder
        header("HTTP/1.0 404 Not Found");
        echo json_encode(array("message" => "Kaynak bulunamadı."));
        break;
}
?>
