<?php
// api/models/Product.php

class Product {
    private $conn;
    private $table_name = "products";

    public $id;
    public $name;
    public $price;
    public $stock;
    public $image; // Ürün görseli yolu

    public function __construct($db) {
        $this->conn = $db;
    }

    // Tüm ürünleri oku
    function read() {
        $query = "SELECT id, name, price, stock, image FROM " . $this->table_name . " ORDER BY name ASC";
        $stmt = $this->conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }

    // Tek bir ürün oku
    function readOne() {
        $query = "SELECT id, name, price, stock, image FROM " . $this->table_name . " WHERE id = ? LIMIT 0,1";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(1, $this->id);
        $stmt->execute();
        $row = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($row) {
            $this->name = $row['name'];
            $this->price = $row['price'];
            $this->stock = $row['stock'];
            $this->image = $row['image'];
            return true;
        }
        return false;
    }

    // Ürün oluştur
    function create() {
        $query = "INSERT INTO " . $this->table_name . " SET name=:name, price=:price, stock=:stock, image=:image";
        $stmt = $this->conn->prepare($query);

        // HTML etiketlerinden ve özel karakterlerden arındır
        $this->name = htmlspecialchars(strip_tags($this->name));
        $this->price = htmlspecialchars(strip_tags($this->price));
        $this->stock = htmlspecialchars(strip_tags($this->stock));
        $this->image = htmlspecialchars(strip_tags($this->image));

        // Parametreleri bağla
        $stmt->bindParam(":name", $this->name);
        $stmt->bindParam(":price", $this->price);
        $stmt->bindParam(":stock", $this->stock);
        $stmt->bindParam(":image", $this->image);

        if ($stmt->execute()) {
            return true;
        }
        return false;
    }

    // Ürün güncelle
    function update() {
        $query = "UPDATE " . $this->table_name . " SET name=:name, price=:price, stock=:stock, image=:image WHERE id = :id";
        $stmt = $this->conn->prepare($query);

        $this->name = htmlspecialchars(strip_tags($this->name));
        $this->price = htmlspecialchars(strip_tags($this->price));
        $this->stock = htmlspecialchars(strip_tags($this->stock));
        $this->image = htmlspecialchars(strip_tags($this->image));
        $this->id = htmlspecialchars(strip_tags($this->id));

        $stmt->bindParam(':name', $this->name);
        $stmt->bindParam(':price', $this->price);
        $stmt->bindParam(':stock', $this->stock);
        $stmt->bindParam(':image', $this->image);
        $stmt->bindParam(':id', $this->id);

        if ($stmt->execute()) {
            return true;
        }
        return false;
    }

    // Ürün sil
    function delete() {
        $query = "DELETE FROM " . $this->table_name . " WHERE id = ?";
        $stmt = $this->conn->prepare($query);

        $this->id = htmlspecialchars(strip_tags($this->id));
        $stmt->bindParam(1, $this->id);

        if ($stmt->execute()) {
            return true;
        }
        return false;
    }

    // Ürün stoğunu güncelle
    function updateStock($product_id, $quantity_change) {
        // Stoğu mevcut miktarla güncelle
        $query = "UPDATE " . $this->table_name . " SET stock = stock + :quantity_change WHERE id = :product_id";
        $stmt = $this->conn->prepare($query);

        $stmt->bindParam(':quantity_change', $quantity_change);
        $stmt->bindParam(':product_id', $product_id);

        if ($stmt->execute()) {
            return true;
        }
        return false;
    }
}
?>
