<?php
// api/models/User.php

class User {
    private $conn;
    private $table_name = "users";

    public $id;
    public $username;
    public $password;
    public $role;

    public function __construct($db) {
        $this->conn = $db;
    }

    // Kullanıcı adı ve şifre ile giriş yapma
    function login() {
        // Kullanıcı adına göre kullanıcıyı bul
        $query = "SELECT id, username, password, role FROM " . $this->table_name . " WHERE username = ? LIMIT 0,1";
        $stmt = $this->conn->prepare($query);

        // HTML etiketlerinden ve özel karakterlerden arındır
        $this->username = htmlspecialchars(strip_tags($this->username));
        $stmt->bindParam(1, $this->username);
        $stmt->execute();
        $row = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($row) {
            // Şifreyi doğrula (MD5 örneği, gerçekte password_verify kullanılmalı)
            if (MD5($this->password) === $row['password']) {
                $this->id = $row['id'];
                $this->username = $row['username'];
                $this->role = $row['role'];
                return true;
            }
        }
        return false;
    }

    // Kullanıcı adına göre rolü al (yetkilendirme için)
    function getRoleByUsername() {
        $query = "SELECT role FROM " . $this->table_name . " WHERE username = ? LIMIT 0,1";
        $stmt = $this->conn->prepare($query);
        $this->username = htmlspecialchars(strip_tags($this->username));
        $stmt->bindParam(1, $this->username);
        $stmt->execute();
        $row = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($row) {
            $this->role = $row['role'];
            return true;
        }
        return false;
    }
}
?>
